#include "MusicManager.h"
#include "dsstdfx.h"



//CWaveFileStream m_Stream;        // WAV file XMO





LPDIRECTSOUND8  m_pDSound = NULL;          // DirectSound object
static CMusicManager*  m_pMusicManager;    // Music Manager

void pauseMusic() {
   m_pMusicManager->Pause();	
}

void resumeMusic() {
   m_pMusicManager->Play();
}

float getVolume() {
    return m_pMusicManager->GetVolume();
}
void setVolume(float v) {
    m_pMusicManager->SetVolume(v); 
}

int initMusic() {
  
	m_pMusicManager = NULL;

    if( FAILED( DirectSoundCreate( NULL, &m_pDSound, NULL ) ) )
        return E_FAIL;

    // download the standard DirectSound effects image
    DSEFFECTIMAGELOC EffectLoc;
    EffectLoc.dwI3DL2ReverbIndex = GraphI3DL2_I3DL2Reverb;
    EffectLoc.dwCrosstalkIndex   = GraphXTalk_XTalk;
    if( FAILED( XAudioDownloadEffectsImage( "d:\\media\\dsstdfx.bin", 
                                            &EffectLoc, 
                                            XAUDIO_DOWNLOADFX_EXTERNFILE, 
                                            NULL ) ) )
        return E_FAIL;

    // Create MusicManager
    m_pMusicManager = new CMusicManager();
    if( !m_pMusicManager )
        return E_OUTOFMEMORY;

    // Initialize MusicManager
    if( FAILED( m_pMusicManager->Initialize() ) )
        return E_FAIL;


	

    m_pMusicManager->SetVolume( 50 );
	m_pMusicManager->Play();


    return S_OK;
}



//-----------------------------------------------------------------------------
// Name: FrameMove()
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
void updateSound()
{

	/*
    // Toggle help
    if( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_BACK ) 
    {
        m_bDrawHelp = !m_bDrawHelp;
    }

    // Toggle playback
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
    {
        if( m_pMusicManager->GetStatus() == MM_PLAYING )
            m_pMusicManager->Stop();
        else
            m_pMusicManager->Play();
    }

    // Switch to next soundtrack
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_X] )
    {
        m_pMusicManager->NextSoundtrack();
    }

    // Switch to next song
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_Y] )
    {
        m_pMusicManager->NextSong();
    }

    // Select a random song
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK] )
    {
        BOOL bWasPlaying = ( m_pMusicManager->GetStatus() == MM_PLAYING ) ? TRUE : FALSE;
        BOOL bWasPaused  = ( m_pMusicManager->GetStatus() == MM_PAUSED ) ? TRUE : FALSE;

        if( bWasPlaying || bWasPaused )
            m_pMusicManager->Stop();

        m_pMusicManager->RandomSong( m_pMusicManager->GetGlobal() );

        if( bWasPlaying || bWasPaused )
            m_pMusicManager->Play();
        if( bWasPaused )
            m_pMusicManager->Pause();
    }

    // Pause playback
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_B] )
    {
        if( m_pMusicManager->GetStatus() == MM_PLAYING )
        {
            m_pMusicManager->Pause();
        }
        else if( m_pMusicManager->GetStatus() == MM_PAUSED )
        {
            m_pMusicManager->Play();
        }
    }

    // Destroy the MusicManager and create a new one
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE] )
    {
        delete m_pMusicManager;
        m_pMusicManager = new CMusicManager();
        if( !m_pMusicManager )
            return E_OUTOFMEMORY;

        if( FAILED( m_pMusicManager->Initialize() ) )
            return E_FAIL;
    }

    // Select between random and sequential play
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] )
    {
        m_pMusicManager->SetRandom( !m_pMusicManager->GetRandom() );
    }

    // Select between global and local play
    if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] )
    {
        m_pMusicManager->SetGlobal( !m_pMusicManager->GetGlobal() );
    }


    FLOAT fVolume = m_pMusicManager->GetVolume();
    fVolume += 2000 * m_DefaultGamepad.fY1 * m_fElapsedTime;
    if( fVolume < DSBVOLUME_MIN )
        fVolume = DSBVOLUME_MIN;
    if( fVolume > DSBVOLUME_MAX )
        fVolume = DSBVOLUME_MAX;
    m_pMusicManager->SetVolume( fVolume );

	*/
	
	//m_pMusicManager->Play();

	//m_pMusicManager->SetVolume( 50 );
    // Let dsound and music manager do some work

	FLOAT fVolume = m_pMusicManager->GetVolume();
    //fVolume += 2000 * m_DefaultGamepad.fY1 * m_fElapsedTime;
    if( fVolume < DSBVOLUME_MIN )
        fVolume = DSBVOLUME_MIN;
    if( fVolume > DSBVOLUME_MAX )
        fVolume = DSBVOLUME_MAX;
    m_pMusicManager->SetVolume( fVolume );


    DirectSoundDoWork();
    m_pMusicManager->Process();

    //return S_OK;


}


